import * as XLSX from "xlsx";

export const exportToExcel = (
  jsonData: any[],
  fileName: string,
  columnsToInclude: any,
) => {
  const getNestedProperty = (obj: any, path: string) => {
    return path.split(".").reduce((acc, part) => acc && acc[part], obj);
  };

  if (columnsToInclude) {
    const filteredData = jsonData.map((row) => {
      const filteredRow: any = {};
      columnsToInclude.forEach(
        (col: string | { key: string; value: string }) => {
          if (typeof col === "string") {
            const value = getNestedProperty(row, col);
            if (value !== undefined) {
              filteredRow[col] = value;
            }
          } else if (typeof col === "object" && col !== null) {
            const value = getNestedProperty(row, col.key);
            if (value !== undefined) {
              filteredRow[col.value] = value;
            }
          }
        },
      );
      return filteredRow;
    });
    jsonData = filteredData;
  }
  const worksheet = XLSX.utils.json_to_sheet(jsonData);
  const workbook = XLSX.utils.book_new();
  XLSX.utils.book_append_sheet(workbook, worksheet, "Sheet1");
  const excelBuffer = XLSX.write(workbook, { bookType: "xlsx", type: "array" });

  const blob = new Blob([excelBuffer], { type: "application/octet-stream" });
  const url = window.URL.createObjectURL(blob);
  const a = document.createElement("a");
  a.href = url;
  a.download = `${fileName}.xlsx`;
  a.click();
  window.URL.revokeObjectURL(url);
  return true;
};
