import { configureStore } from "@reduxjs/toolkit";
import { authSlice } from "./auth/authSlice";
import { usersSlice } from "./users/userSlice";
import { categorySlice } from "./categories/categorySlice";
import { productSlice } from "./products/productSlice";
import { cartSlice } from "./cart/cartSlice";
import { orderSlice } from "./orders/orderSlice";
import { customerSlice } from "./customers/customerSlice";

export const store = configureStore({
	reducer: {
		auth: authSlice.reducer,
		users: usersSlice.reducer,
		categories: categorySlice.reducer,
		products: productSlice.reducer,
		cart: cartSlice.reducer,
		orders: orderSlice.reducer,
		customers: customerSlice.reducer,
	},
});
export type RootState = ReturnType<typeof store.getState>;
export type AppDispatch = typeof store.dispatch;
