import { ProductTypes } from "@/types/ProductTypes";
import { createAsyncThunk, createSlice } from "@reduxjs/toolkit";

interface CartType {
	loading: "idle" | "pending" | "succeeded" | "failed";
	cart: ProductTypes[];
	tax: number;
	total: number;
	error: string | null;
}
const initialState: CartType = {
	loading: "idle",
	cart: [],
	total: 0,
	tax: 0,
	error: null,
};

export const cartSlice = createSlice({
	name: "cart",
	initialState,
	reducers: {
		addToCart: (state, action) => {
			const existingProduct = state.cart.find(
				(item) => item.id === action.payload.id
			);
			if (existingProduct) {
				existingProduct.quantity += action.payload.quantity;
			} else {
				state.cart.push(action.payload);
			}

			state.total = state.cart.reduce(
				(total: number, item: ProductTypes) =>
					total +
					(typeof item.priceInCents === "number"
						? item.priceInCents * item.quantity
						: 0),
				0
			);
			state.tax = state.total * 0.16;
		},
		removeFromcart: (state, action) => {
			state.cart = state.cart.filter((item) => (item.id! = action.payload.id));
		},
	},
});

export const { addToCart } = cartSlice.actions;
