"use client";
import React, { useEffect } from "react";
import Link from "next/link";
import { Icons } from "@/utils/Icons";
import { AppDispatch, RootState } from "@/lib/store/store";
import { useDispatch, useSelector } from "react-redux";
import { fetchCategories } from "@/lib/store/categories/categorySlice";
import Image from "next/image";
import { Components } from "../Index";
export default function Categories() {
	const dispatch = useDispatch<AppDispatch>();
	const categories = useSelector(
		(state: RootState) => state.categories.categories
	);
	const isLoading = useSelector((state: RootState) => state.categories.loading);
	// const router = useRouter();
	useEffect(() => {
		dispatch(fetchCategories());
	}, []);
	return (
		<div className='container px-4 md:px-6 py-8'>
			<div className='flex items-center justify-between mb-6'>
				<h2 className='text-2xl font-bold'>Shop by Category</h2>
				<Link
					href='/categories'
					className='text-primary hover:underline'
					prefetch={false}>
					View All
				</Link>
			</div>
			<div className="overflow-x-auto [&::-webkit-scrollbar]:hidden [-ms-overflow-style:'none'] [scrollbar-width:'none']">
				{isLoading === "pending" ? (
					<Components.LoadingComponent />
				) : (
					<div className='flex gap-4 py-2'>
						{categories.map((category) => (
							<Link
								key={category.id}
								href='#'
								className='flex flex-col items-center gap-2 shrink-0'
								prefetch={false}>
								<div className='bg-muted rounded-full p-3'>
									<Image
										src={category.image}
										alt={category.name}
										width={50}
										height={50}
									/>
								</div>
								<span className='text-sm font-medium'>{category.name}</span>
							</Link>
						))}
					</div>
				)}
			</div>
		</div>
	);
}
