"use client";

import { TrendingUp } from "lucide-react";
import { CartesianGrid, Line, LineChart, XAxis } from "recharts";

import {
	Card,
	CardContent,
	CardDescription,
	CardFooter,
	CardHeader,
	CardTitle,
} from "@/components/ui/card";
import {
	ChartConfig,
	ChartContainer,
	ChartTooltip,
	ChartTooltipContent,
} from "@/components/ui/chart";

export const description = "A multiple line chart";

const chartData = [
	{ month: "January", fulfilled: 186, cancelled: 80 },
	{ month: "February", fulfilled: 305, cancelled: 200 },
	{ month: "March", fulfilled: 237, cancelled: 120 },
	{ month: "April", fulfilled: 73, cancelled: 190 },
	{ month: "May", fulfilled: 209, cancelled: 130 },
	{ month: "June", fulfilled: 214, cancelled: 140 },
];

const chartConfig = {
	fulfilled: {
		label: "fulfilled",
		color: "#10b981",
	},
	cancelled: {
		label: "cancelled",
		color: "#ef4444",
	},
} satisfies ChartConfig;

export function OrderStatusChart() {
	return (
		<Card>
			<CardHeader>
				<CardTitle>Fulfilled Orders/Cancelled</CardTitle>
				<CardDescription>January - Oct 2024</CardDescription>
			</CardHeader>
			<CardContent>
				<ChartContainer config={chartConfig}>
					<LineChart
						accessibilityLayer
						data={chartData}
						margin={{
							left: 12,
							right: 12,
						}}>
						<CartesianGrid vertical={false} />
						<XAxis
							dataKey='month'
							tickLine={false}
							axisLine={false}
							tickMargin={8}
							tickFormatter={(value) => value.slice(0, 3)}
						/>
						<ChartTooltip cursor={false} content={<ChartTooltipContent />} />
						<Line
							dataKey='fulfilled'
							type='monotone'
							stroke='var(--color-fulfilled)'
							strokeWidth={2}
							dot={true}
						/>
						<Line
							dataKey='cancelled'
							type='monotone'
							stroke='var(--color-cancelled)'
							strokeWidth={2}
							dot={true}
						/>
					</LineChart>
				</ChartContainer>
			</CardContent>
		</Card>
	);
}
