import { seo } from "@/utils/seo";
import Image from "next/image";
import React from "react";

export default function FooterComponent() {
	return (
		<>
			<footer className='main-footer-index3'>
				<div
					className='footer-logo wow zoomIn animated'
					data-wow-delay='0ms'
					data-wow-duration='1500ms'
					style={{
						visibility: "visible",
						animationDuration: "1500ms",
						animationDelay: "0ms",
						animationName: "zoomIn",
					}}>
					<a href='#'>
						<span>
							<Image
								src={seo.logo}
								alt=''
								width={200}
								height={250}
								className='w-[230px] filter brightness-0 invert'
							/>
						</span>
					</a>
				</div>
				<div className='auto-container'>
					<div className='row clearfix'>
						<div className='col-lg-5 col-md-6 col-sm-12'>
							<div className='footer-widgets text-widet'>
								<p>
									At Al-Mahdi Auto Parts Ltd, we are dedicated to providing
									top-quality automotive parts, specializing in commercial
									vehicles. As the sole distributor of Textar brake friction in
									Kenya, we bring world-className safety and reliability to the
									market. But we don’t stop there—our extensive product range
									covers all essential components to keep your fleet in top
									condition.
								</p>
								<a href='https://almahdi.splendidmedia.co.ke/cart'>SHOP NOW</a>
							</div>
						</div>
						<div className='col-lg-3 col-md-6 col-sm-12'>
							<div className='footer-widgets link-widet'>
								<div className='text-widet'>
									<h2>Quick Link</h2>
								</div>
								<ul>
									<li>
										<a href='#'>Home</a>
									</li>
									<li>
										<a href='#'>About</a>
									</li>
									<li>
										<a href='#'>Partners</a>
									</li>
									<li>
										<a href='#'>Contact</a>
									</li>
								</ul>
							</div>
						</div>
						<div className='col-lg-3 col-md-6 col-sm-12'>
							<div className='footer-widgets text-widet'>
								<h2>Contact us</h2>
								<p className='no-pd'>
									Machakos Road, Railway Station, Mombasa Kenya
								</p>
								<ul>
									<li>
										<i className='icon fa fa-phone-square'></i>
										<span>+254 798 889026</span>
									</li>
									<li>
										<i className='sicon fa fa-envelope'></i>
										<span>sales@al-mahdiautopartsltd.com</span>
									</li>
								</ul>
								<ul className='footer-social'>
									<li>
										<a
											href='https://www.facebook.com/almahdiautopartsltd/'
											target='_blank'>
											<span className='fab fa-facebook-f'></span>
										</a>
									</li>
									<li>
										<a
											href='https://www.instagram.com/almahdiautopartsltd/'
											target='_blank'>
											<span className='fab fa-instagram'></span>
										</a>
									</li>
								</ul>
							</div>
						</div>
					</div>
					<div className='copyright'>
						© Almahdi All rights reserved. Designed by{" "}
						<a href='https://splendidmedia.co.ke' target='_blank'>
							{" "}
							Splendid Media Limited
						</a>
					</div>
				</div>
			</footer>
		</>
	);
}
