import db from "@/utils/db";
import { NextRequest, NextResponse } from "next/server";
import { promises as fs } from "fs";
import path from "path";
import { v4 as uuidv4 } from "uuid";

export async function POST(req: NextRequest) {
	const formData = await req.formData();
	const name = formData.get("name") as string;
	const image = formData.get("image") as File;

	const user = await db.category.findFirst({
		where: { name: name },
	});
	if (user) {
		return NextResponse.json(
			{ error: "Category already exists" },
			{ status: 400 }
		);
	} else {
		try {
			// Save the image to the public folder
			const imageBuffer = Buffer.from(await image.arrayBuffer());
			const imageName = `${uuidv4()}-${image.name}`;
			const imagePath = path.join(
				process.cwd(),
				"public",
				"images",
				"categories",
				imageName
			);
			await fs.writeFile(imagePath, imageBuffer);

			const category = await db.category.create({
				data: {
					name,
					image: `/images/categories/${imageName}`,
				},
			});

			return NextResponse.json(
				{ message: "Category created successfuly", category },
				{ status: 200 }
			);
		} catch (error) {
			return NextResponse.json(
				{ error: "Failed to create category" },
				{ status: 500 }
			);
		}
	}
}

export async function GET(req: NextRequest) {
	const category = await db.category.findMany({
		select: {
			id: true,
			name: true,
			image: true,
			createdAt: true,
			updatedAt: true,
			_count: { select: { products: true } },
		},
	});
	return NextResponse.json(category, { status: 200 });
}
