"use client";
import React, { useEffect } from "react";
import AdminLayout from "../layout";
import {
	Breadcrumb,
	BreadcrumbItem,
	BreadcrumbLink,
	BreadcrumbList,
	BreadcrumbPage,
	BreadcrumbSeparator,
} from "@/components/ui/breadcrumb";

import {
	Table,
	TableBody,
	TableCell,
	TableHead,
	TableHeader,
	TableRow,
} from "@/components/ui/table";
import Link from "next/link";
import { Badge } from "@/components/ui/badge";
import {
	DropdownMenu,
	DropdownMenuCheckboxItem,
	DropdownMenuContent,
	DropdownMenuItem,
	DropdownMenuLabel,
	DropdownMenuSeparator,
	DropdownMenuTrigger,
} from "@radix-ui/react-dropdown-menu";
import { Button } from "@/components/ui/button";
import { Icons } from "@/utils/Icons";
import {
	Card,
	CardContent,
	CardDescription,
	CardHeader,
	CardTitle,
} from "@/components/ui/card";
import { exportToExcel } from "@/utils/exportToExcel";
import { useDispatch, useSelector } from "react-redux";
import { AppDispatch, RootState } from "@/lib/store/store";
import {
	deleteCategory,
	fetchCategories,
} from "@/lib/store/categories/categorySlice";
import { Components } from "@/components/Index";
import { formartDate } from "@/utils/formartDate";
import Image from "next/image";

export default function Categories() {
	const dispatch = useDispatch<AppDispatch>();
	const categories = useSelector(
		(state: RootState) => state.categories.categories
	);
	const isLoading = useSelector((state: RootState) => state.categories.loading);
	// const router = useRouter();
	useEffect(() => {
		dispatch(fetchCategories());
	}, []);

	const deleteCategories = async (id: string) => {
		const data = await dispatch(deleteCategory({ id }));
		if (data.meta.requestStatus === "fulfilled") {
			window.location.reload();
		}
	};
	return (
		<AdminLayout>
			<div className='flex flex-col sm:gap-4 sm:py-4 sm:pl-14'>
				<header className='sticky top-0 z-30 flex h-14 items-center gap-4 border-b bg-background px-4 sm:static sm:h-auto sm:border-0 sm:bg-transparent sm:px-6'>
					<Breadcrumb className='hidden md:flex'>
						<BreadcrumbList>
							<BreadcrumbItem>
								<BreadcrumbLink asChild>
									<Link href='/admin'>Dashboard</Link>
								</BreadcrumbLink>
							</BreadcrumbItem>
							<BreadcrumbSeparator />
							<BreadcrumbItem>
								<BreadcrumbLink asChild>
									<Link href='/admin/categories'>Categories</Link>
								</BreadcrumbLink>
							</BreadcrumbItem>

							<BreadcrumbSeparator />
							<BreadcrumbItem>
								<BreadcrumbPage>All</BreadcrumbPage>
							</BreadcrumbItem>
						</BreadcrumbList>
					</Breadcrumb>
				</header>
				<div className='ml-auto flex items-center gap-2'>
					<DropdownMenu>
						<DropdownMenuTrigger asChild>
							<Button variant='outline' size='sm' className='h-8 gap-1'>
								<Icons.ListFilter className='h-3.5 w-3.5' />
								<span className='sr-only sm:not-sr-only sm:whitespace-nowrap'>
									Filter By
								</span>
							</Button>
						</DropdownMenuTrigger>
						<DropdownMenuContent align='end'>
							<DropdownMenuSeparator />
							<DropdownMenuCheckboxItem checked>
								Active
							</DropdownMenuCheckboxItem>
							<DropdownMenuCheckboxItem>Inactive</DropdownMenuCheckboxItem>
						</DropdownMenuContent>
					</DropdownMenu>
					<Button
						size='sm'
						variant='outline'
						className='h-8 gap-1'
						onClick={() =>
							exportToExcel(categories, "categories", [
								"id",
								"name",
								"image",
								"createdAt",
								"updatedAt",
							])
						}>
						<Icons.File className='h-3.5 w-3.5' />
						<span className='sr-only sm:not-sr-only sm:whitespace-nowrap'>
							Export
						</span>
					</Button>
					<Link href='/admin/categories/add'>
						<Button size='sm' className='h-8 gap-1'>
							<Icons.PlusCircle className='h-3.5 w-3.5' />
							<span className='sr-only sm:not-sr-only sm:whitespace-nowrap'>
								Add New
							</span>
						</Button>
					</Link>
				</div>
				{isLoading === "pending" ? (
					<Components.LoadingComponent />
				) : categories.length > 0 ? (
					<Card x-chunk='dashboard-06-chunk-0'>
						<CardHeader>
							<CardTitle>Categories</CardTitle>
							<CardDescription>
								Manage your Categories and view their sales performance.
							</CardDescription>
						</CardHeader>
						<CardContent>
							<Table>
								<TableHeader>
									<TableRow>
										<TableHead>Image</TableHead>
										<TableHead>Name</TableHead>
										<TableHead>Products</TableHead>
										<TableHead className='hidden md:table-cell'>
											Created at
										</TableHead>
										<TableHead className='hidden md:table-cell'>
											Updated At
										</TableHead>
										<TableHead>Actions</TableHead>
									</TableRow>
								</TableHeader>
								<TableBody>
									{categories.map((category) => (
										<TableRow key={category.name}>
											<TableCell>
												<Image
													src={category.image}
													alt={category.name}
													width={40}
													height={40}
												/>
											</TableCell>
											<TableCell className='font-medium'>
												{category.name}
											</TableCell>

											<TableCell className='font-medium'>
												{category?._count?.products}
											</TableCell>

											<TableCell className='hidden md:table-cell'>
												{formartDate(category.createdAt)}
											</TableCell>

											<TableCell className='hidden md:table-cell'>
												{formartDate(category.updatedAt)}
											</TableCell>
											<TableCell>
												<DropdownMenu>
													<DropdownMenuTrigger asChild>
														<Button
															aria-haspopup='true'
															size='icon'
															variant='ghost'>
															<Icons.MoreHorizontal className='h-4 w-4' />
															<span className='sr-only'>Toggle menu</span>
														</Button>
													</DropdownMenuTrigger>
													<DropdownMenuContent align='end'>
														<DropdownMenuItem>Edit</DropdownMenuItem>
														<DropdownMenuItem
															onClick={() => deleteCategories(category.id)}>
															Delete
														</DropdownMenuItem>
													</DropdownMenuContent>
												</DropdownMenu>
											</TableCell>
										</TableRow>
									))}
								</TableBody>
							</Table>
						</CardContent>
					</Card>
				) : (
					<Card x-chunk='dashboard-06-chunk-0'>
						<CardHeader>
							<CardTitle>Categories</CardTitle>
							<CardDescription>Manage your Categories</CardDescription>
						</CardHeader>
						<CardContent>
							<Badge>No Categories Found</Badge>
						</CardContent>
					</Card>
				)}
			</div>
		</AdminLayout>
	);
}
