"use client";
import Image from "next/image";
import Link from "next/link";
import React, { useEffect } from "react";
import { Button } from "../ui/button";
import { useDispatch, useSelector } from "react-redux";
import { AppDispatch, RootState } from "@/lib/store/store";
import { fetchProducts } from "@/lib/store/products/productSlice";
import { Component } from "lucide-react";
import { Components } from "../Index";
import { Badge } from "../ui/badge";
import { addToCart } from "@/lib/store/cart/cartSlice";
import { ProductTypes } from "@/types/ProductTypes";
import { Icons } from "@/utils/Icons";

export default function ProductList() {
	const dispatch = useDispatch<AppDispatch>();
	const products = useSelector((state: RootState) => state.products.products);
	const isLoading = useSelector((state: RootState) => state.products.loading);
	const cartIsLoading = useSelector((state: RootState) => state.cart.loading);

	useEffect(() => {
		dispatch(fetchProducts());
	}, []);

	const addTocart = (product: ProductTypes) => {
		let newProduct = product;
		newProduct = { ...newProduct, quantity: 1 };
		dispatch(addToCart(newProduct));
	};
	return (
		<div className='container px-4 md:px-6 py-8'>
			<div className='flex items-center justify-between mb-6'>
				<h2 className='text-2xl font-bold'>Featured Products</h2>
				<Link
					href='#'
					className='text-primary hover:underline'
					prefetch={false}>
					View All
				</Link>
			</div>
			{isLoading === "pending" ? (
				<Components.LoadingComponent />
			) : (
				<div className='grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-6 '>
					{products.map((product) => (
						<>
							<div
								key={product.id}
								className='bg-background rounded-lg shadow-lg overflow-hidden group border-2 border-primary-800 relative'>
								{!product.isAvailableForPurchase && (
									<div className='absolute top-0 right-0 bg-red-500 text-white py-1 px-3 rotate-45 transform translate-x-8 -translate-y-2 shadow-md'>
										Out of Order
									</div>
								)}
								<Image
									src={product.image}
									alt={product.name}
									width='300'
									height='300'
									className='w-full h-72 object-cover group-hover:opacity-80 transition-opacity'
									style={{ aspectRatio: "300/300", objectFit: "cover" }}
								/>
								<div className='p-4'>
									<h3 className='text-lg font-semibold mb-2'>
										<Link
											href={`/products/${product.id}`}
											className='hover:text-primary'
											prefetch={false}>
											{product.name}{" "}
										</Link>
									</h3>
									<Badge variant='outline' className='mb-2'>
										{product.category.name}
									</Badge>
									<p className='text-muted-foreground text-sm mb-4'>
										{product.description}
									</p>
									<div className='flex items-center justify-between'>
										<span className='text-lg font-bold'>
											KES {product.priceInCents}
										</span>

										{cartIsLoading === "pending" ? (
											<Button disabled>
												<Icons.Loader2 className='mr-2 h-4 w-4 animate-spin' />
												Please wait
											</Button>
										) : (
											<Button
												className={`${product.isAvailableForPurchase} ? "bg-muted" : "bg-muted"}`}
												size={"sm"}
												variant={
													product.isAvailableForPurchase
														? "default"
														: "secondary"
												}
												disabled={!product.isAvailableForPurchase}
												onClick={() => addTocart(product)}>
												{product.isAvailableForPurchase
													? "Add to Cart"
													: "Out of Stock"}
											</Button>
										)}
									</div>
								</div>
							</div>
						</>
					))}
				</div>
			)}
		</div>
	);
}
