"use client";
import { RootState } from "@/lib/store/store";
import { Icons } from "@/utils/Icons";
import { seo } from "@/utils/seo";
import Image from "next/image";
import Link from "next/link";
import React, { useEffect } from "react";
import { useSelector } from "react-redux";

export default function HeaderComponent() {
	const cart = useSelector((state: RootState) => state.cart.cart);

	useEffect(() => {}, [cart]);
	return (
		<header className='bg-white border-b-2 text-foreground '>
			<div className='container py-4 px-6 flex items-center justify-between '>
				<Link href='/' className='flex items-center gap-2' prefetch={false}>
					<Image src={seo.logo} width={200} height={250} alt={seo.brand} />
					{/* <span className='text-lg font-semibold'>{seo.brand}</span> */}
				</Link>
				<div className='flex items-center gap-4'>
					{/* <Link
						href='/login'
						className='hover:underline font-bold'
						prefetch={false}>
						Login
					</Link> */}
					<Link
						href='/admin'
						className='hover:underline font-bold'
						prefetch={false}>
						Admin
					</Link>
					<Link href='/cart' className='relative font-bold' prefetch={false}>
						<Icons.ShoppingBag className='h-6 w-6 text-primary' />
						<span className='absolute -top-2 -right-2 font-bold bg-accent text-foreground rounded-full px-2 py-0.5 text-xs'>
							{cart.length}
						</span>
					</Link>
				</div>
			</div>
		</header>
	);
}
