"use client";
import React from "react";
import { useRouter } from "next/navigation";
import { Button } from "@/components/ui/button";
import {
	Card,
	CardContent,
	CardDescription,
	CardHeader,
	CardTitle,
} from "@/components/ui/card";
import { Input } from "@/components/ui/input";
import { Label } from "@/components/ui/label";
import { useDispatch } from "react-redux";
import { login } from "@/lib/store/auth/authSlice";
import { AppDispatch } from "@/lib/store/store";
import { useForm } from "react-hook-form";

export default function LoginComponent() {
	const dispatch = useDispatch<AppDispatch>();
	const router = useRouter();
	const {
		register,
		handleSubmit,
		watch,
		formState: { errors },
	} = useForm();
	const formData = watch();
	const handleLogin = async () => {
		const loginRes = await dispatch(login(formData));
		console.log(loginRes);
		if (loginRes.meta.requestStatus === "fulfilled") {
			router.push("/admin");
			window.location.reload();
		}
	};

	return (
		<div className='flex justify-center items-center min-h-screen'>
			<Card className='mx-auto max-w-sm '>
				<CardHeader>
					<CardTitle className='text-2xl'>Login</CardTitle>
					<CardDescription>
						Enter your email below to login to your account
					</CardDescription>
				</CardHeader>
				<CardContent>
					<form onSubmit={handleSubmit(handleLogin)} className='grid gap-4'>
						<div className='grid gap-2'>
							<Label htmlFor='email'>Email</Label>
							<Input
								id='email'
								type='email'
								placeholder='enter your work email'
								{...register("email", {
									required: "Email is required",
									pattern: {
										value: /^[a-zA-Z0-9._%+-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}$/,
										message: "Invalid email address",
									},
								})}
							/>
							{errors.email && (
								<div className='text-destructive'>
									{errors.email?.message?.toString()}
								</div>
							)}
						</div>
						<div className='grid gap-2'>
							<div className='flex items-center'>
								<Label htmlFor='password'>Password</Label>
							</div>
							<Input
								id='password'
								type='password'
								{...register("password", {
									required: "Password is required",
									minLength: {
										value: 6,
										message: "Password must be at least 6 characters long",
									},
								})}
							/>
							{errors.password && (
								<div className='text-destructive'>
									{errors.password?.message?.toString()}
								</div>
							)}
						</div>

						<Button type='submit' className='w-full'>
							Login
						</Button>
					</form>
				</CardContent>
			</Card>
		</div>
	);
}
