"use client";
import { Icons } from "@/utils/Icons";
import Link from "next/link";
import React from "react";
import {
	Tooltip,
	TooltipContent,
	TooltipProvider,
	TooltipTrigger,
} from "@/components/ui/tooltip";
import Image from "next/image";
import { seo } from "@/utils/seo";
import { AppDispatch } from "@/lib/store/store";
import { useDispatch } from "react-redux";
import { autoLogout } from "@/lib/store/auth/authSlice";
import { useRouter } from "next/navigation";

export default function AdminSidebar() {
	const dispatch = useDispatch<AppDispatch>();
	const router = useRouter();

	const logout = async () => {
		dispatch(autoLogout());
		router.push("/admin");
		window.location.reload();
	};

	return (
		<aside className='fixed inset-y-0 left-0 z-10 hidden w-20 flex-col border-r bg-background sm:flex'>
			<nav className='flex flex-col items-center gap-4 px-2 sm:py-5'>
				<Link href='/admin'>
					<Image src={seo.logo} width={200} height={300} alt={seo.brand} />
					<span className='sr-only'>Al-Hamdi Auto spares</span>
				</Link>
				<TooltipProvider>
					<Tooltip>
						<TooltipTrigger asChild>
							<Link
								href='/admin'
								className='flex h-12 w-12 items-center justify-center rounded-lg bg-accent text-muted-foreground transition-colors hover:text-foreground md:h-8 md:w-8'>
								<Icons.Home className='h-5 w-5' />
								<span className='sr-only'>Dashboard</span>
							</Link>
						</TooltipTrigger>
						<TooltipContent side='right'>Dashboard</TooltipContent>
					</Tooltip>
					<Tooltip>
						<TooltipTrigger asChild>
							<Link
								href='/admin/orders'
								className='flex h-12 w-12 items-center justify-center rounded-lg text-accent-foreground transition-colors hover:text-foreground md:h-8 md:w-8'>
								<Icons.ShoppingCart className='h-5 w-5' />
								<span className='sr-only'>Orders</span>
							</Link>
						</TooltipTrigger>
						<TooltipContent side='right'>Orders</TooltipContent>
					</Tooltip>
					<Tooltip>
						<TooltipTrigger asChild>
							<Link
								href='/admin/products'
								className='flex h-12 w-12 items-center justify-center rounded-lg text-muted-foreground transition-colors hover:text-foreground md:h-8 md:w-8'>
								<Icons.Package className='h-5 w-5' />
								<span className='sr-only'>Products</span>
							</Link>
						</TooltipTrigger>
						<TooltipContent side='right'>Products</TooltipContent>
					</Tooltip>
					<Tooltip>
						<TooltipTrigger asChild>
							<Link
								href='/admin/categories'
								className='flex h-12 w-12 items-center justify-center rounded-lg text-muted-foreground transition-colors hover:text-foreground md:h-8 md:w-8'>
								<Icons.FolderOpenDot className='h-5 w-5' />
								<span className='sr-only'>Categories</span>
							</Link>
						</TooltipTrigger>
						<TooltipContent side='right'>Categories</TooltipContent>
					</Tooltip>
					<Tooltip>
						<TooltipTrigger asChild>
							<Link
								href='/admin/customers'
								className='flex h-12 w-12 items-center justify-center rounded-lg text-muted-foreground transition-colors hover:text-foreground md:h-8 md:w-8'>
								<Icons.Users2 className='h-5 w-5' />
								<span className='sr-only'>Customers</span>
							</Link>
						</TooltipTrigger>
						<TooltipContent side='right'>Customers</TooltipContent>
					</Tooltip>
					<Tooltip>
						<TooltipTrigger asChild>
							<Link
								href='/admin/users'
								className='flex h-12 w-12 items-center justify-center rounded-lg text-muted-foreground transition-colors hover:text-foreground md:h-8 md:w-8'>
								<Icons.SquareUserRound className='h-5 w-5' />
								<span className='sr-only'>Users</span>
							</Link>
						</TooltipTrigger>
						<TooltipContent side='right'>Users</TooltipContent>
					</Tooltip>
					<Tooltip>
						<TooltipTrigger asChild onClick={() => logout()}>
							<span className='flex h-12 w-12 items-center justify-center rounded-lg text-muted-foreground transition-colors hover:text-foreground md:h-8 md:w-8'>
								<Icons.LogOut className='h-5 w-5' />
								<span className='sr-only'>Logout</span>
							</span>
						</TooltipTrigger>
						<TooltipContent side='right'>Logout</TooltipContent>
					</Tooltip>
				</TooltipProvider>
			</nav>
		</aside>
	);
}
