import React from "react";
import {
	Carousel,
	CarouselContent,
	CarouselItem,
	CarouselNext,
	CarouselPrevious,
} from "@/components/ui/carousel";
import Link from "next/link";
import { Icons } from "@/utils/Icons";
import Image from "next/image";
export default function CarouselComponent() {
	return (
		<section className='w-full mx-auto'>
			<Carousel className='w-full h-full'>
				<CarouselContent>
					<CarouselItem>
						<div className='relative h-full w-full overflow-hidden'>
							<Image
								src='/images/banners/banner-default.jpg'
								alt='Carousel Image 1'
								className='h-full w-full object-cover'
								width='600'
								height='200'
								style={{ aspectRatio: "600/200", objectFit: "cover" }}
							/>
							{/* <div className='absolute inset-0 flex flex-col items-center justify-center space-y-4 bg-gradient-to-t from-[rgba(0,0,0,0.5)] to-[rgba(0,0,0,0)]'>
								<h2 className='text-3xl font-bold text-white sm:text-4xl md:text-5xl'>
									Discover the Future
								</h2>
								<p className='text-lg text-white md:text-xl'>
									Experience the latest technology today.
								</p>
								<Link
									href='#'
									className='inline-flex h-10 items-center justify-center rounded-md bg-primary px-6 py-2 text-sm font-medium text-primary-foreground shadow transition-colors hover:bg-primary/90 focus-visible:outline-none focus-visible:ring-1 focus-visible:ring-ring disabled:pointer-events-none disabled:opacity-50'
									prefetch={false}>
									Learn More
								</Link>
							</div> */}
						</div>
					</CarouselItem>
					<CarouselItem>
						<div className='relative h-full w-full overflow-hidden'>
							<Image
								src='/images/banners/banner-default.jpg'
								alt='Carousel Image 1'
								className='h-full w-full object-cover'
								width='600'
								height='200'
								style={{ aspectRatio: "600/200", objectFit: "cover" }}
							/>
							{/* <div className='absolute inset-0 flex flex-col items-center justify-center space-y-4 bg-gradient-to-t from-[rgba(0,0,0,0.5)] to-[rgba(0,0,0,0)]'>
								<h2 className='text-3xl font-bold text-white sm:text-4xl md:text-5xl'>
									Discover the Future
								</h2>
								<p className='text-lg text-white md:text-xl'>
									Experience the latest technology today.
								</p>
								<Link
									href='#'
									className='inline-flex h-10 items-center justify-center rounded-md bg-primary px-6 py-2 text-sm font-medium text-primary-foreground shadow transition-colors hover:bg-primary/90 focus-visible:outline-none focus-visible:ring-1 focus-visible:ring-ring disabled:pointer-events-none disabled:opacity-50'
									prefetch={false}>
									Learn More
								</Link>
							</div> */}
						</div>
					</CarouselItem>
					<CarouselItem>
						<div className='relative h-full w-full overflow-hidden'>
							<Image
								src='/images/banners/banner-default.jpg'
								alt='Carousel Image 1'
								className='h-full w-full object-cover'
								width='600'
								height='200'
								style={{ aspectRatio: "600/200", objectFit: "cover" }}
							/>
							{/* <div className='absolute inset-0 flex flex-col items-center justify-center space-y-4 bg-gradient-to-t from-[rgba(0,0,0,0.5)] to-[rgba(0,0,0,0)]'>
								<h2 className='text-3xl font-bold text-white sm:text-4xl md:text-5xl'>
									Discover the Future
								</h2>
								<p className='text-lg text-white md:text-xl'>
									Experience the latest technology today.
								</p>
								<Link
									href='#'
									className='inline-flex h-10 items-center justify-center rounded-md bg-primary px-6 py-2 text-sm font-medium text-primary-foreground shadow transition-colors hover:bg-primary/90 focus-visible:outline-none focus-visible:ring-1 focus-visible:ring-ring disabled:pointer-events-none disabled:opacity-50'
									prefetch={false}>
									Learn More
								</Link>
							</div> */}
						</div>
					</CarouselItem>
				</CarouselContent>
				<CarouselPrevious className='absolute left-4 top-1/2 -translate-y-1/2 rounded-full bg-white/50 p-2 shadow transition-colors hover:bg-white focus-visible:outline-none focus-visible:ring-1 focus-visible:ring-ring'>
					<Icons.ChevronLeftIcon className='h-6 w-6 text-muted-foreground' />
					<span className='sr-only'>Previous</span>
				</CarouselPrevious>
				<CarouselNext className='absolute right-4 top-1/2 -translate-y-1/2 rounded-full bg-white/50 p-2 shadow transition-colors hover:bg-white focus-visible:outline-none focus-visible:ring-1 focus-visible:ring-ring'>
					<Icons.ChevronRightIcon className='h-6 w-6 text-muted-foreground' />
					<span className='sr-only'>Next</span>
				</CarouselNext>
				<div className='absolute bottom-4 left-1/2 -translate-x-1/2 space-x-2'>
					<div />
					<div />
					<div />
				</div>
			</Carousel>
		</section>
	);
}
