import React from "react";
import {
	Carousel,
	CarouselContent,
	CarouselItem,
	CarouselNext,
	CarouselPrevious,
} from "@/components/ui/carousel";
import Image from "next/image";
import { data } from "@/utils/data";
export default function Banners() {
	return (
		<>
			<Carousel className='w-full'>
				<CarouselContent>
					{data.banners.map((banner, key) => (
						<CarouselItem key={key}>
							<Image
								src={banner.image}
								alt='Banner 1'
								width='1200'
								height='620'
								className='w-full object-cover'
								style={{ aspectRatio: "1200/620", objectFit: "cover" }}
							/>
						</CarouselItem>
					))}
				</CarouselContent>
				<CarouselPrevious />
				<CarouselNext />
			</Carousel>
		</>
	);
}
