import type { Metadata } from "next";
import { Inter } from "next/font/google";
import "./globals.css";

const inter = Inter({ subsets: ["latin"] });

export const metadata: Metadata = {
	title: "Al-Hamdi Auto Spares",
	description: "Al-Hamdi Autospares",
};

import { ReactNode } from "react";
import { Toaster } from "react-hot-toast";
import StoreProvider from "./admin/StoreProvider";

interface RootLayoutProps {
	children: ReactNode;
}

export default function RootLayout({ children }: RootLayoutProps) {
	return (
		<html lang='en'>
			<body className={inter.className}>
				<main className='flex-1 bg-white'>
					<Toaster
						toastOptions={{
							style: {
								fontSize: "10px",
							},
						}}
						position='top-right'
					/>
					<StoreProvider>{children}</StoreProvider>
				</main>
			</body>
		</html>
	);
}
