"use client";
import React, { useEffect, useState } from "react";
import {
	ChevronRight,
	Copy,
	CreditCard,
	MoreVertical,
	Truck,
} from "lucide-react";

import { Button } from "@/components/ui/button";
import {
	Card,
	CardContent,
	CardDescription,
	CardHeader,
	CardTitle,
} from "@/components/ui/card";
import {
	DropdownMenu,
	DropdownMenuContent,
	DropdownMenuItem,
	DropdownMenuSeparator,
	DropdownMenuTrigger,
} from "@/components/ui/dropdown-menu";
import { Separator } from "@/components/ui/separator";
import { Icons } from "@/utils/Icons";
import { Components } from "@/components/Index";
import { useDispatch, useSelector } from "react-redux";
import { AppDispatch, RootState } from "@/lib/store/store";
import { ProductTypes } from "@/types/ProductTypes";
import Link from "next/link";
import { Input } from "@/components/ui/input";
import { useForm } from "react-hook-form";
import { createOrder } from "@/lib/store/orders/orderSlice";
import { useRouter } from "next/navigation";

export default function CartPage() {
	const dispatch = useDispatch<AppDispatch>();
	const cart = useSelector((state: RootState) => state.cart.cart);
	const total = useSelector((state: RootState) => state.cart.total);
	const tax = useSelector((state: RootState) => state.cart.tax);
	const [phoneNumber, setPhoneNumber] = useState("254700500505"); //254798889026
	const isLoading = useSelector((state: RootState) => state.cart.loading);
	const router = useRouter();
	const {
		register,
		handleSubmit,
		formState: { errors, isValid },
		watch,
	} = useForm();
	const formData = watch();
	useEffect(() => {
		// dispatch()
		console.log("cart:", cart);
	}, [cart]);

	const handleOrder = async () => {
		formData.cart = cart;
		formData.pricePaidInCents = total;
		console.log(formData);
		const res = await dispatch(createOrder(formData));
		if (res.meta.requestStatus === "fulfilled") {
			// router.push("/");
			// window.location.reload();
			// window.location.href("")
			const url = generateWhatsAppMessage(phoneNumber);
			window.open(url, "_blank")?.focus();
		}
	};

	const generateWhatsAppMessage = (phoneNumber: string) => {
		const itemsMessage = cart.map((item) => {
			const subtotal = (item.priceInCents * item.quantity).toFixed(2);
			return `- Order Items: KES ${item.name} (x${item.quantity}) - KES *${subtotal}* \n\n`;
		});

		const totalMessage = `- Total: KES *${total.toFixed(2)}*`;
		const message = `- Shopping Cart Order - From \n\n ${formData.name}, \n\n - 
		${formData.phone} \n\n - delivery address: ${formData.address} - ${
			formData.town
		} ${itemsMessage.join("\n")}\n\n${totalMessage}`;

		// const encodedMessage = encodeURIComponent(message);
		const whatsappURL = `https://wa.me/${phoneNumber}?text=${message}`;

		return whatsappURL;
	};

	return (
		<>
			<Components.HeaderComponent />
			<Components.CarouselComponent />
			<div className='flex justify-center items-center mx-auto mt-10 mb-10 gap-3'>
				<CardContent className='p-6 text-sm'>
					{cart.length === 0 ? (
						<>
							<p>Your Cart Is Empty</p>
							<p className='text-primary mt-4'>
								<Link href={"/"}>Start Shopping</Link>
							</p>
						</>
					) : (
						<>
							<div className='grid gap-3'>
								<div className='font-semibold'>Order Details</div>
								<ul className='grid gap-3'>
									{cart.map((item: ProductTypes) => (
										<li
											className='flex items-center justify-between'
											key={item.id}>
											<span className='text-muted-foreground'>
												{item.name} x <span>{item.quantity}</span>
											</span>
											<span>{item.priceInCents}</span>
											<span>KES {item.priceInCents * item.quantity}</span>
										</li>
									))}
								</ul>
								<Separator className='my-2' />
								<ul className='grid gap-3'>
									<li className='flex items-center justify-between'>
										<span className='text-muted-foreground'>Subtotal</span>
										<span>KES {total}</span>
									</li>
									<li className='flex items-center justify-between'>
										<span className='text-muted-foreground'>Shipping</span>
										<span>KES 0.00</span>
									</li>
									<li className='flex items-center justify-between'>
										<span className='text-muted-foreground'>Tax</span>
										<span>KES {tax}</span>
									</li>
									<li className='flex items-center justify-between font-semibold'>
										<span className='text-muted-foreground'>Total</span>
										<span>KES {tax + total}</span>
									</li>
								</ul>
							</div>
							{formData.name || formData.address ? (
								<>
									<Separator className='my-4' />
									<div className='grid grid-cols-2 gap-4'>
										<div className='grid gap-3'>
											<div className='font-semibold'>Shipping Information</div>
											<address className='grid gap-0.5 not-italic text-muted-foreground'>
												<span>{formData.name}</span>
												<span>{formData.address}</span>
												<span>{formData.town}</span>
											</address>
										</div>
									</div>
								</>
							) : (
								""
							)}
							{formData.name || formData.address ? (
								<>
									<Separator className='my-4' />
									<div className='grid gap-3'>
										<div className='font-semibold'>Customer Information</div>
										<dl className='grid gap-3'>
											<div className='flex items-center justify-between'>
												<dt className='text-muted-foreground'>Customer</dt>
												<dd>{formData.name}</dd>
											</div>
											{formData.email && (
												<div className='flex items-center justify-between'>
													<dt className='text-muted-foreground'>Email</dt>
													<dd>
														<a href='mailto:'>{formData.email}</a>
													</dd>
												</div>
											)}
											<div className='flex items-center justify-between'>
												<dt className='text-muted-foreground'>Phone</dt>
												<dd>
													<a href='tel:'>{formData.phone}</a>
												</dd>
											</div>
										</dl>
									</div>
								</>
							) : (
								""
							)}
						</>
					)}
				</CardContent>

				{cart.length > 0 && (
					<Card
						className='overflow-hidden bg-white min-w-md  max-w-lg'
						x-chunk='dashboard-05-chunk-4'>
						<CardContent className='p-6 text-sm'>
							<div className='grid gap-3'>
								<div className='font-semibold'>Shipping Details</div>
							</div>
							<form onSubmit={handleSubmit(handleOrder)}>
								<div className='mt-2'>
									<label htmlFor='name'>Name *</label>
									<Input
										id='name'
										type='text'
										{...register("name", {
											required: true,
										})}
									/>
									{errors.name && (
										<p className='text-destructive'>
											{errors?.name?.message?.toString()}
										</p>
									)}
								</div>
								<div className='mt-2'>
									<label htmlFor='name'>Phone *</label>
									<Input
										id='phone'
										type='text'
										{...register("phone", {
											required: true,
										})}
									/>
									{errors.phone && (
										<p className='text-destructive'>
											{errors?.phone?.message?.toString()}
										</p>
									)}
								</div>
								<div className='mt-2'>
									<label htmlFor='town'>Delivery Town *</label>
									<Input
										id='town'
										type='text'
										{...register("town", {
											required: true,
										})}
									/>
									{errors.town && (
										<p className='text-destructive'>
											{errors?.town?.message?.toString()}
										</p>
									)}
								</div>
								<div className='mt-2'>
									<label htmlFor='address'>Delivery Address *</label>
									<Input
										id='address'
										type='text'
										{...register("address", {
											required: true,
										})}
									/>
									{errors.address && (
										<p className='text-destructive'>
											{errors?.address?.message?.toString()}
										</p>
									)}
								</div>
								<div className='mt-2'>
									<label htmlFor='email'>Email</label>
									<Input id='email' type='text' {...register("email")} />
									{errors.email && (
										<p className='text-destructive'>
											{errors?.email?.message?.toString()}
										</p>
									)}
								</div>
								<div className='grid gap-3'>
									<div className='font-semibold mt-4'>Checkout</div>
									<Button
										type='submit'
										size='sm'
										variant='outline'
										className='h-8 gap-1 mt-4'>
										<Icons.ShoppingCart className='h-3.5 w-3.5' />
										<span className='lg:sr-only xl:not-sr-only xl:whitespace-nowrap'>
											{isLoading === "pending" ? (
												<Components.LoadingComponent />
											) : (
												"Order Now"
											)}
										</span>
									</Button>
								</div>
							</form>
						</CardContent>
					</Card>
				)}
			</div>
		</>
	);
}
