import db from "@/utils/db";
import { NextRequest, NextResponse } from "next/server";
const bcrypt = require("bcrypt");

export async function POST(req: NextRequest) {
	const { name, email, role, status, password, phone } = await req.json();
	const user = await db.user.findUnique({
		where: { email: email },
	});
	if (user) {
		return NextResponse.json({ error: "User already exists" }, { status: 400 });
	} else {
		try {
			const hashedPassword = await bcrypt.hash(password, 10);

			const user = await db.user.create({
				data: {
					name,
					email,
					role,
					status,
					password: hashedPassword,
					phone,
				},
			});
			return NextResponse.json(
				{ message: "user created successfuly", user },
				{ status: 200 }
			);
		} catch (error) {
			return NextResponse.json(
				{ error: "Failed to create user" },
				{ status: 500 }
			);
		}
	}
}

export async function GET(req: NextRequest) {
	const users = await db.user.findMany();
	return NextResponse.json(users, { status: 200 });
}
