import db from "@/utils/db";
import { NextRequest, NextResponse } from "next/server";
const bcrypt = require("bcrypt");
import jwt from "jsonwebtoken";

export async function POST(req: NextRequest) {
	const { email, password } = await req.json();

	if (email === "" && password === "") {
		return NextResponse.json(
			{ error: "Email and password are required" },
			{ status: 400 }
		);
	}

	const user = await db.user.findUnique({
		where: { email },
	});
	if (!user) {
		return NextResponse.json({ error: "User not found" }, { status: 404 });
	}
	const isPasswordValid = await bcrypt.compare(password, user.password);
	if (!isPasswordValid) {
		return NextResponse.json(
			{ error: "Invalid email or password" },
			{ status: 400 }
		);
	} else {
		const token = jwt.sign(
			{ email: user.email, name: user.name, id: user.id },
			process.env.JWT_SECRET || "secret",
			{ expiresIn: "1h" }
		);

		return NextResponse.json(
			{ message: "Login successful", user: user, access: token },
			{ status: 200 }
		);
	}
}
