"use client";
import React, { useEffect } from "react";
import AdminLayout from "../layout";
import {
	Breadcrumb,
	BreadcrumbItem,
	BreadcrumbLink,
	BreadcrumbList,
	BreadcrumbPage,
	BreadcrumbSeparator,
} from "@/components/ui/breadcrumb";
import Link from "next/link";

import {
	Table,
	TableBody,
	TableCell,
	TableHead,
	TableHeader,
	TableRow,
} from "@/components/ui/table";
import { Badge } from "@/components/ui/badge";
import {
	DropdownMenu,
	DropdownMenuCheckboxItem,
	DropdownMenuContent,
	DropdownMenuGroup,
	DropdownMenuItem,
	DropdownMenuLabel,
	DropdownMenuSeparator,
	DropdownMenuTrigger,
} from "@radix-ui/react-dropdown-menu";
import { Button } from "@/components/ui/button";
import { Icons } from "@/utils/Icons";
import {
	Card,
	CardContent,
	CardDescription,
	CardHeader,
	CardTitle,
} from "@/components/ui/card";
import { useDispatch, useSelector } from "react-redux";
import { AppDispatch, RootState } from "@/lib/store/store";
import { Components } from "@/components/Index";
import { UserType } from "@/types/UserTypes";
import { formartDate } from "@/utils/formartDate";
import { deleteUser, fetchUsers } from "@/lib/store/users/userSlice";
import { data } from "@/utils/data";
import { exportToExcel } from "@/utils/exportToExcel";
// import { useRouter } from "next/navigation";

export default function Users() {
	const dispatch = useDispatch<AppDispatch>();
	const users = useSelector((state: RootState) => state.users.users);
	const isLoading = useSelector((state: RootState) => state.users.loading);
	// const router = useRouter();
	useEffect(() => {
		dispatch(fetchUsers());
	}, []);

	const deleteUsers = async (id: string) => {
		const data = await dispatch(deleteUser({ id }));
		if (data.meta.requestStatus === "fulfilled") {
			window.location.reload();
		}
	};
	return (
		<AdminLayout>
			<div className='flex flex-col sm:gap-4 sm:py-4 sm:pl-14'>
				<header className='sticky top-0 z-30 flex h-14 items-center gap-4 border-b bg-background px-4 sm:static sm:h-auto sm:border-0 sm:bg-transparent sm:px-6'>
					<Breadcrumb className='hidden md:flex'>
						<BreadcrumbList>
							<BreadcrumbItem>
								<BreadcrumbLink asChild>
									<Link href='/admin'>Dashboard</Link>
								</BreadcrumbLink>
							</BreadcrumbItem>
							<BreadcrumbSeparator />
							<BreadcrumbItem>
								<BreadcrumbLink asChild>
									<Link href='/admin/users' className='underline'>
										Users
									</Link>
								</BreadcrumbLink>
							</BreadcrumbItem>
							<BreadcrumbSeparator />
							<BreadcrumbItem>
								<BreadcrumbPage>All</BreadcrumbPage>
							</BreadcrumbItem>
						</BreadcrumbList>
					</Breadcrumb>
				</header>
				<div className='ml-auto flex items-center gap-2'>
					<DropdownMenu>
						<DropdownMenuTrigger asChild>
							<Button variant='outline' size='sm' className='h-8 gap-1'>
								<Icons.ListFilter className='h-3.5 w-3.5' />
								<span className='sr-only sm:not-sr-only sm:whitespace-nowrap'>
									Filter By Status
								</span>
							</Button>
						</DropdownMenuTrigger>
						<DropdownMenuContent align='end'>
							<DropdownMenuSeparator />
							<DropdownMenuCheckboxItem checked>
								Active
							</DropdownMenuCheckboxItem>
							<DropdownMenuCheckboxItem>Inactive</DropdownMenuCheckboxItem>
						</DropdownMenuContent>
					</DropdownMenu>
					<DropdownMenu>
						<DropdownMenuTrigger asChild>
							<Button variant='outline' size='sm' className='h-8 gap-1'>
								<Icons.ListFilter className='h-3.5 w-3.5' />
								<span className='sr-only sm:not-sr-only sm:whitespace-nowrap'>
									Filter By Role
								</span>
							</Button>
						</DropdownMenuTrigger>
						<DropdownMenuContent align='end'>
							<DropdownMenuSeparator />
							{data.roles.map((role) => (
								<DropdownMenuCheckboxItem key={role.label}>
									{role.value}
								</DropdownMenuCheckboxItem>
							))}
						</DropdownMenuContent>
					</DropdownMenu>
					<Button
						size='sm'
						variant='outline'
						className='h-8 gap-1'
						onClick={() =>
							exportToExcel(users, "users", [
								"id",
								"email",
								"name",
								"phone",
								"status",
							])
						}>
						<Icons.File className='h-3.5 w-3.5' />
						<span className='sr-only sm:not-sr-only sm:whitespace-nowrap'>
							Export
						</span>
					</Button>
					<Link href='/admin/users/add'>
						<Button size='sm' className='h-8 gap-1'>
							<Icons.PlusCircle className='h-3.5 w-3.5' />
							<span className='sr-only sm:not-sr-only sm:whitespace-nowrap'>
								Add New
							</span>
						</Button>
					</Link>
				</div>
				{isLoading === "pending" ? (
					<Components.LoadingComponent />
				) : users.length === 0 ? (
					<Card x-chunk='dashboard-06-chunk-0'>
						<CardHeader>
							<CardTitle>Users</CardTitle>
							<CardDescription>Manage your Staff.</CardDescription>
						</CardHeader>
						<CardContent>
							<Badge>No Users Found</Badge>
						</CardContent>
					</Card>
				) : (
					<Card x-chunk='dashboard-06-chunk-0 ' className='bg-white'>
						<CardHeader>
							<CardTitle>Users</CardTitle>
							<CardDescription>Manage your Staff.</CardDescription>
						</CardHeader>
						<CardContent>
							<Table>
								<TableHeader>
									<TableRow>
										<TableHead>Name</TableHead>
										<TableHead>Email</TableHead>
										<TableHead>Phone</TableHead>
										<TableHead>Role</TableHead>
										<TableHead>Status</TableHead>
										<TableHead>Date Joined</TableHead>
										<TableHead>Actions</TableHead>
									</TableRow>
								</TableHeader>
								<TableBody>
									{users.map((user: UserType) => (
										<TableRow key={user.id}>
											<TableCell>{user.name}</TableCell>
											<TableCell>{user.email}</TableCell>
											<TableCell>{user.phone}</TableCell>
											<TableCell>{user.role}</TableCell>
											<TableCell>
												<Badge
													className='text-xs'
													variant={`${
														user.status === "ACTIVE"
															? "secondary"
															: "destructive"
													}`}>
													{user.status}
												</Badge>
											</TableCell>
											<TableCell>{formartDate(user.createdAt)}</TableCell>
											<TableCell>
												<DropdownMenu>
													<DropdownMenuTrigger asChild>
														<Button
															aria-haspopup='true'
															size='icon'
															variant='ghost'>
															<Icons.MoreHorizontal className='h-4 w-4' />
															<span className='sr-only'>Toggle menu</span>
														</Button>
													</DropdownMenuTrigger>
													<DropdownMenuContent align='end'>
														<DropdownMenuGroup>
															<DropdownMenuItem>
																<Link href={`/admin/users/${user.id}`}>
																	Edit
																</Link>
															</DropdownMenuItem>
															<DropdownMenuItem
																onClick={() => deleteUsers(user.id)}>
																Delete
															</DropdownMenuItem>
														</DropdownMenuGroup>
													</DropdownMenuContent>
												</DropdownMenu>
											</TableCell>
										</TableRow>
									))}
								</TableBody>
							</Table>
						</CardContent>
					</Card>
				)}
			</div>
		</AdminLayout>
	);
}
