"use client";
import React, { useEffect } from "react";

import { AdminComponents } from "@/components/admin/Index";
import StoreProvider from "./StoreProvider";
import Cookies from "js-cookie";

export default function AdminLayout({
	children,
}: Readonly<{
	children: React.ReactNode;
}>) {
	const token = Cookies.get("token") ?? null;
	const authUser = JSON.parse(Cookies.get("authUser") ?? "{}");

	return token ? (
		<div className='flex min-h-screen w-full flex-col mb-4 bg-white'>
			<AdminComponents.AdminSidebar />
			<main className='flex-1 items-start flex-col gap-4 p-4 sm:px-6 sm:py-0 md:gap-8 lg:grid-cols-3 xl:grid-cols-3'>
				{children}
			</main>
		</div>
	) : (
		<AdminComponents.LoginComponent />
	);
}
