"use client";
import React, { useEffect } from "react";
import Link from "next/link";

import { Badge } from "@/components/ui/badge";
import {
	Breadcrumb,
	BreadcrumbItem,
	BreadcrumbLink,
	BreadcrumbList,
	BreadcrumbPage,
	BreadcrumbSeparator,
} from "@/components/ui/breadcrumb";
import {
	Card,
	CardContent,
	CardDescription,
	CardHeader,
	CardTitle,
} from "@/components/ui/card";
import {
	Table,
	TableBody,
	TableCell,
	TableHead,
	TableHeader,
	TableRow,
} from "@/components/ui/table";
import AdminLayout from "../layout";
import { useDispatch, useSelector } from "react-redux";
import { AppDispatch, RootState } from "@/lib/store/store";
import { useRouter } from "next/navigation";
import { fetchCustomers } from "@/lib/store/customers/customerSlice";
export default function Customers() {
	const dispatch = useDispatch<AppDispatch>();
	const customers = useSelector(
		(state: RootState) => state.customers.customers
	);
	const isLoading = useSelector((state: RootState) => state.customers.loading);
	const router = useRouter();
	useEffect(() => {
		dispatch(fetchCustomers());
	}, []);
	return (
		<AdminLayout>
			<div className='flex flex-col sm:gap-4 sm:py-4 sm:pl-14'>
				<header className='sticky top-0 z-30 flex h-14 items-center gap-4 border-b bg-background px-4 sm:static sm:h-auto sm:border-0 sm:bg-transparent sm:px-6'>
					<Breadcrumb className='hidden md:flex'>
						<BreadcrumbList>
							<BreadcrumbItem>
								<BreadcrumbLink asChild>
									<Link href='#'>Dashboard</Link>
								</BreadcrumbLink>
							</BreadcrumbItem>
							<BreadcrumbSeparator />
							<BreadcrumbItem>
								<BreadcrumbLink asChild>
									<Link href='#'>Customers</Link>
								</BreadcrumbLink>
							</BreadcrumbItem>
							<BreadcrumbSeparator />
							<BreadcrumbItem>
								<BreadcrumbPage>All</BreadcrumbPage>
							</BreadcrumbItem>
						</BreadcrumbList>
					</Breadcrumb>
				</header>
				<Card x-chunk='dashboard-05-chunk-3'>
					<CardHeader className='px-7'>
						<CardTitle>Customers</CardTitle>
						<CardDescription>All Your Customers.</CardDescription>
					</CardHeader>
					<CardContent>
						<Table>
							<TableHeader>
								<TableRow>
									<TableHead>Customer</TableHead>
									<TableHead>Phone</TableHead>
									<TableHead className='hidden sm:table-cell'>
										Address
									</TableHead>
									<TableHead className='hidden sm:table-cell'>Town</TableHead>
									<TableHead className='hidden sm:table-cell'>Status</TableHead>
									<TableHead className='hidden md:table-cell'>
										Date Joined
									</TableHead>
									<TableHead className='text-right'>Total Orders</TableHead>
									<TableHead className='text-right'>Sales</TableHead>
								</TableRow>
							</TableHeader>
							<TableBody>
								{customers.map((customer) => (
									<TableRow className='bg-accent' key={customer.id}>
										<TableCell>
											<div className='font-medium'>{customer.name}</div>
											<div className='hidden text-sm text-muted-foreground md:inline'>
												{customer.email}
											</div>
										</TableCell>
										<TableCell>{customer.phone}</TableCell>
										<TableCell>{customer.address}</TableCell>
										<TableCell>{customer.town}</TableCell>

										<TableCell className='hidden sm:table-cell'>
											<Badge className='text-xs' variant='secondary'>
												{customer.status}
											</Badge>
										</TableCell>
										<TableCell className='hidden md:table-cell'>
											{customer.createdAt}
										</TableCell>

										<TableCell className='text-right'>
											{customer._count.orders}
										</TableCell>
										<TableCell className='text-right'>
											{customer.sales}
										</TableCell>
									</TableRow>
								))}
							</TableBody>
						</Table>
					</CardContent>
				</Card>
			</div>
		</AdminLayout>
	);
}
