"use client";
import React, { use, useRef, useState } from "react";
import Image from "next/image";
import {
	Breadcrumb,
	BreadcrumbItem,
	BreadcrumbLink,
	BreadcrumbList,
	BreadcrumbPage,
	BreadcrumbSeparator,
} from "@/components/ui/breadcrumb";
import {
	Card,
	CardContent,
	CardDescription,
	CardFooter,
	CardHeader,
	CardTitle,
} from "@/components/ui/card";
import {
	Table,
	TableBody,
	TableCell,
	TableHead,
	TableHeader,
	TableRow,
} from "@/components/ui/table";
import { Badge } from "@/components/ui/badge";
import {
	DropdownMenu,
	DropdownMenuCheckboxItem,
	DropdownMenuContent,
	DropdownMenuItem,
	DropdownMenuLabel,
	DropdownMenuSeparator,
	DropdownMenuTrigger,
} from "@/components/ui/dropdown-menu";
import { Tabs, TabsContent, TabsList, TabsTrigger } from "@/components/ui/tabs";
import { Button } from "@/components/ui/button";
import Link from "next/link";
import { Icons } from "@/utils/Icons";
import AdminLayout from "../../layout";
import { useForm } from "react-hook-form";
import { useDispatch, useSelector } from "react-redux";
import { AppDispatch, RootState } from "@/lib/store/store";
import { AdminComponents } from "@/components/admin/Index";
import { createCategory } from "@/lib/store/categories/categorySlice";
import { useRouter } from "next/navigation";
import toast from "react-hot-toast";
export default function AddCategory() {
	const loading = useSelector((state: RootState) => state.categories.loading);
	const [fileName, setFileName] = useState("");
	const fileInputRef = useRef(null);
	const [fileUrl, setFileUrl] = useState("");
	const {
		handleSubmit,
		register,
		watch,
		setValue,
		formState: { errors, isValid },
	} = useForm();
	const formData = watch();
	const dispatch = useDispatch<AppDispatch>();
	const router = useRouter();
	const handleDragOver = (e: React.DragEvent<HTMLDivElement>) => {
		e.preventDefault();
	};

	const handleDrop = (e: React.DragEvent<HTMLDivElement>) => {
		e.preventDefault();
		const files = e.dataTransfer.files;
		if (files.length) {
			setFileName(files[0].name);
			setFileUrl(URL.createObjectURL(files[0]));
			setValue("image", files[0]); // Set the file in the form data
		}
	};

	const handleFileChange = (e: React.ChangeEvent<HTMLInputElement>) => {
		const files = e.target.files;
		if (files && files.length) {
			setFileName(files[0].name);
			setFileUrl(URL.createObjectURL(files[0]));
			setValue("image", files[0]); // Set the file in the form data
		}
	};

	const cancel = () => {
		//clear the formData
		setFileName("");
		setFileUrl("");
	};

	const handleBrowseClick = () => {
		(fileInputRef.current as HTMLInputElement | null)?.click();
	};

	const handleAddCategory = async (data: any) => {
		const formDataToSend = new FormData();
		if (formData.image) {
			formDataToSend.append("image", formData.image);
			formDataToSend.append("name", formData.name);
			const response = await fetch("/api/categories", {
				method: "POST",
				body: formDataToSend,
			});
			if (response.ok) {
				router.push("/admin/categories");
				window.location.reload();
			} else {
				console.log("error:", response);
				toast.error(response.statusText);
			}

			// const data = await dispatch(createCategory(formDataToSend));
			// if (data.meta.requestStatus === "fulfilled") {
			// 	router.push("/admin/categories");
			// 	window.location.reload();
			// }
		}
	};
	return (
		<AdminLayout>
			<div className='flex flex-col sm:gap-4 sm:py-4 sm:pl-14'>
				<header className='sticky top-0 z-30 flex h-14 items-center gap-4 border-b bg-background px-4 sm:static sm:h-auto sm:border-0 sm:bg-transparent sm:px-6'>
					<Breadcrumb className='hidden md:flex'>
						<BreadcrumbList>
							<BreadcrumbItem>
								<BreadcrumbLink asChild>
									<Link href='/admin'>Dashboard</Link>
								</BreadcrumbLink>
							</BreadcrumbItem>
							<BreadcrumbSeparator />
							<BreadcrumbItem>
								<BreadcrumbLink asChild>
									<Link href='/admin/categories'>Categories</Link>
								</BreadcrumbLink>
							</BreadcrumbItem>
							<BreadcrumbSeparator />
							<BreadcrumbItem>
								<BreadcrumbPage>Add New</BreadcrumbPage>
							</BreadcrumbItem>
						</BreadcrumbList>
					</Breadcrumb>
				</header>
				<form
					className='w-full max-w-lg'
					onSubmit={handleSubmit(handleAddCategory)}>
					<div className='w-full'>
						<label
							className='block uppercase text-secondary text-xs font-bold mb-2'
							htmlFor='name'>
							Name *
						</label>
						<input
							className={`appearance-none block w-full bg-transparent text-secondary border border-tertiary/25 rounded-md py-3 px-4 mb-3 leading-tight focus:outline-none focus:bg-white focus:border-tertiary/25 ${
								errors.url ? "border-red-600" : ""
							}`}
							id='name'
							type='text'
							placeholder='Category Name'
							{...register("name", { required: true })}
						/>{" "}
						{errors.url && (
							<p className='mt-2 mb-2 text-xs   text-red-600 font-bold'>
								NameL is required.
							</p>
						)}
					</div>
					<div
						className={`border-2 border-dashed border-tertiary/25 rounded-lg p-6 text-center`}
						onDragOver={handleDragOver}
						onDrop={handleDrop}>
						<p className='text-gray-500 mb-4'>
							{fileName || "Drag and drop your file here"}
						</p>
						<p className='text-gray-500 mb-4'>or</p>
						<button
							onClick={handleBrowseClick}
							className='bg-black text-white px-4 py-2 rounded-md hover:bg-gray-800'>
							Browse Files
						</button>
						<input
							type='file'
							className={`hidden`}
							{...register("image", { required: true })}
							onChange={(e) => {
								handleFileChange(e);
							}}
							ref={fileInputRef}
						/>
						{errors.image && (
							<p className='mt-2 mb-2 text-xs text-red-600 font-bold'>
								Image is required.
							</p>
						)}
						{fileUrl && (
							<Image
								src={fileUrl}
								width={0}
								height={200}
								alt={fileName}
								style={{ width: "100%" }}
								className='mt-5 border border-tertiary/25 rounded-lg'
							/>
						)}
					</div>
					<div className='flex justify-end items-center space-x-3 py-4'>
						<Button
							className='btn bg-transparent text-danger  font-bold hover:bg-transparent border w-40 border-danger hover:border-danger'
							onClick={() => cancel()}>
							Cancel
						</Button>
						<Button
							type='submit'
							// disabled={!isValid}
							className={`btn ${
								!isValid
									? "cursor-not-allowed  hover:bg-tertiary/25 focus:outline-none bg-tertiary/25 text-secondary"
									: "bg-secondary text-active font-bold hover:bg-secondary "
							}  font-bold border w-40 border-tertiary/25 hover:border-tertiary/25`}>
							{loading === "pending" ? (
								<AdminComponents.LoginComponent />
							) : (
								"Save"
							)}
						</Button>
					</div>
				</form>
			</div>
		</AdminLayout>
	);
}
